;----PROGRAMMA MICROCONTROLLORE 2051 PER LA GESTIONE DELL'ADC 0808----
;---------------------------------------------------------------------
;ASSEGNAZIONE DEI PIN                -
;                                    -
;PULSANTE SELECT ATT BASSO --> P3.7  -
;PIN INDIRIZZO MENO SING   --> P1.0  -
;PIN INDIRIZZO PIU' SING   --> P1.1  -
;INIZIO CONVERSIONE        --> P1.2  -
;AGGANCIO INDIRIZZO (ALE)  --> P1.3  - 
;-------------------------------------
;_____________________________________________________________________
;
;ASSEMBLY [2051]
;
    ORG 0000H
;
INIZIO:  MOV P1,#0H             ;INIZIALIZZAZIONE PORTA P1
         MOV 50H,#0H            ;INIZIALIZZAZIONE CONTATORE
         AJMP TEMP              ;SALTO A CONVERSIONE TEMPERATURA
INCREM:  MOV A,50H              
         INC A                  ;INCREMENTO CONTATORE
         MOV 50H,A
SELECT:  JB A.1,PREVEL          ;SE BIT A.1  UGUALE A 1 SALTO A SELEZIONE PRESSIONE VENTO
         JB A.0,UMID            ;SE BIT A.0  UGUALE A 0 SALTO A CONVERSIONE UMIDITA'
         AJMP TEMP              ;SALTO A CONVERSIONE TEMPERATURA
PREVEL:  JB A.0,VENT            ;SE BIT A.0  UGUALE A 1 SALTO A CONVERSIONE VELUCITA' VENTO
         AJMP PRES              ;SALTA A CONVERSIONE PRESSIONE ATMOSFERICA
VENT:    LJMP VVEN
;---------------------------------------------------------------------------------------------
TEMP:    MOV P1,#0H             ;DO INDIRIZZO        
         NOP                    ;
         NOP                    ;
         NOP                    ;
AGGINDT: MOV P1,#8H             ;AGGANCIO INDIRIZZO
RITT:    MOV R0,#10             ;RITARDO 100mS 
RIT1:    MOV R1,#100            ;
RIT2:    MOV R2,#50             ;
         DJNZ R2,$              ;
         DJNZ R1,RIT2           ;
         DJNZ R0,RIT1           ;
CONVT:   MOV P1,#0CH            ;INIZIO CONVERSIONE
RITTC:   MOV R0,#20             ;RITARDO 200mS 
RIT3:    MOV R1,#100            ;
RIT4:    MOV R2,#50             ;
         DJNZ R2,$              ;
         DJNZ R1,RIT4           ;
         DJNZ R0,RIT3           ;
ENDT:    MOV P1,#0H             ;END CONV/ALE
RIT1S:   MOV R0,#100            ;RITARDO 1S 
RIT5:    MOV R1,#100            ;
RIT6:    MOV R2,#50             ;
         DJNZ R2,$              ;
         DJNZ R1,RIT6           ;
         DJNZ R0,RIT5           ;
         JB P3.7,TEMP           ;SE IL TASTO NON  PREMUTO SALTA A TEMP ALTRIMENTI PROSEGUI
         JNB P3.7,$             ;SE IL TASTO E PREMUTO BLOCCA PROGRAMMA ALTRIMENTI PROSEGUI
         AJMP INCREM            ;SALTA A INCREM
;----------------------------------------------------------------------------------------------
UMID:    MOV P1,#1H             ;DO INDIRIZZO        
         NOP                    ;
         NOP                    ;
         NOP                    ;
AGGINDU: MOV P1,#9H             ;AGGANCIO INDIRIZZO
RITU:    MOV R0,#10             ;RITARDO 100mS 
RIT7:    MOV R1,#100            ;
RIT8:    MOV R2,#50             ;
         DJNZ R2,$              ;
         DJNZ R1,RIT8           ;
         DJNZ R0,RIT7           ;
CONVU:   MOV P1,#0DH            ;INIZIO CONVERSIONE
RITUC:   MOV R0,#20             ;RITARDO 200mS 
RIT9:    MOV R1,#100            ;
RIT10:   MOV R2,#50             ;
         DJNZ R2,$              ;
         DJNZ R1,RIT10          ;
         DJNZ R0,RIT9           ;
ENDU:    MOV P1,#1H             ;END CONV/ALE
RITU1S:  MOV R0,#100            ;RITARDO 1S 
RIT11:   MOV R1,#100            ;
RIT12:   MOV R2,#50             ;
         DJNZ R2,$              ;
         DJNZ R1,RIT12          ;
         DJNZ R0,RIT11          ;
         JB P3.7,UMID           ;SE IL TASTO NON  PREMUTO SALTA A TEMP ALTRIMENTI PROSEGUI
         JNB P3.7,$             ;SE IL TASTO E PREMUTO BLOCCA PROGRAMMA ALTRIMENTI PROSEGUI
         AJMP INCREM            ;SALTA A INCREM
;----------------------------------------------------------------------------------------------
PRES:    MOV P1,#2H             ;DO INDIRIZZO        
         NOP                    ;
         NOP                    ;
         NOP                    ;
AGGINDP: MOV P1,#0AH            ;AGGANCIO INDIRIZZO
RITP:    MOV R0,#10             ;RITARDO 100mS 
RIT13:   MOV R1,#100            ;
RIT14:   MOV R2,#50             ;
         DJNZ R2,$              ;
         DJNZ R1,RIT14          ;
         DJNZ R0,RIT13          ;
CONVP:   MOV P1,#0EH            ;INIZIO CONVERSIONE
RITPC:   MOV R0,#20             ;RITARDO 200mS 
RIT15:   MOV R1,#100            ;
RIT16:   MOV R2,#50             ;
         DJNZ R2,$              ;
         DJNZ R1,RIT16          ;
         DJNZ R0,RIT15          ;
ENDP:    MOV P1,#2H             ;END CONV/ALE
RITP1S:  MOV R0,#100            ;RITARDO 1S 
RIT17:   MOV R1,#100            ;
RIT18:   MOV R2,#50             ;
         DJNZ R2,$              ;
         DJNZ R1,RIT18          ;
         DJNZ R0,RIT17          ;
         JB P3.7,PRES           ;SE IL TASTO NON  PREMUTO SALTA A TEMP ALTRIMENTI PROSEGUI
         JNB P3.7,$             ;SE IL TASTO E PREMUTO BLOCCA PROGRAMMA ALTRIMENTI PROSEGUI
         AJMP INCREM            ;SALTA A INCREM
;----------------------------------------------------------------------------------------------
VVEN:    MOV P1,#3H             ;DO INDIRIZZO        
         NOP                    ;
         NOP                    ;
         NOP                    ;
AGGINDV: MOV P1,#0BH            ;AGGANCIO INDIRIZZO
RITV:    MOV R0,#10             ;RITARDO 100mS 
RIT19:   MOV R1,#100            ;
RIT20:   MOV R2,#50             ;
         DJNZ R2,$              ;
         DJNZ R1,RIT20          ;
         DJNZ R0,RIT19          ;
CONVV:   MOV P1,#0FH            ;INIZIO CONVERSIONE
RITVC:   MOV R0,#20             ;RITARDO 200mS 
RIT21:   MOV R1,#100            ;
RIT22:   MOV R2,#50             ;
         DJNZ R2,$              ;
         DJNZ R1,RIT22          ;
         DJNZ R0,RIT21          ;
ENDV:    MOV P1,#3H             ;END CONV/ALE
RITV1S:  MOV R0,#100            ;RITARDO 1S 
RIT23:   MOV R1,#100            ;
RIT24:   MOV R2,#50             ;
         DJNZ R2,$              ;
         DJNZ R1,RIT24          ;
         DJNZ R0,RIT23          ;
         JB P3.7,VVEN           ;SE IL TASTO NON  PREMUTO SALTA A TEMP ALTRIMENTI PROSEGUI
         JNB P3.7,$             ;SE IL TASTO E PREMUTO BLOCCA PROGRAMMA ALTRIMENTI PROSEGUI
         AJMP INCREM            ;SALTA A INCREM
;----------------------------------------------------------------------------------------------
